/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.beans;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.beans.SamePropertyValuesAs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamePropertyValuesAsTest
extends AbstractMatcherTest {
    private static final Value aValue = new Value("expected");
    private static final ExampleBean expectedBean = new ExampleBean("same", 1, aValue);
    private static final ExampleBean actualBean = new ExampleBean("same", 1, aValue);

    @Override
    protected Matcher<?> createMatcher() {
        return SamePropertyValuesAs.samePropertyValuesAs((Object)expectedBean);
    }

    public void testReportsMatchWhenAllPropertiesMatch() {
        SamePropertyValuesAsTest.assertMatches("matched properties", SamePropertyValuesAs.samePropertyValuesAs((Object)expectedBean), actualBean);
    }

    public void testReportsMismatchWhenActualTypeIsNotAssignableToExpectedType() {
        SamePropertyValuesAsTest.assertMismatchDescription("is incompatible type: ExampleBean", SamePropertyValuesAs.samePropertyValuesAs((Object)aValue), actualBean);
    }

    public void testReportsMisatchOnFirstPropertyDifference() {
        SamePropertyValuesAsTest.assertMismatchDescription("string was \"different\"", SamePropertyValuesAs.samePropertyValuesAs((Object)expectedBean), new ExampleBean("different", 1, aValue));
        SamePropertyValuesAsTest.assertMismatchDescription("int was <2>", SamePropertyValuesAs.samePropertyValuesAs((Object)expectedBean), new ExampleBean("same", 2, aValue));
        SamePropertyValuesAsTest.assertMismatchDescription("value was <Value other>", SamePropertyValuesAs.samePropertyValuesAs((Object)expectedBean), new ExampleBean("same", 1, new Value("other")));
    }

    public void testMatchesBeansWithInheritanceButNoExtraProperties() {
        SamePropertyValuesAsTest.assertMatches("sub type with same properties", SamePropertyValuesAs.samePropertyValuesAs((Object)expectedBean), new SubBeanWithNoExtraProperties("same", 1, aValue));
    }

    public void testRejectsSubTypeThatHasExtraProperties() {
        SamePropertyValuesAsTest.assertMismatchDescription("has extra properties called [extra]", SamePropertyValuesAs.samePropertyValuesAs((Object)expectedBean), new SubBeanWithExtraProperty("same", 1, aValue));
    }

    public void testDescribesItself() {
        SamePropertyValuesAsTest.assertDescription("same property values as ExampleBean [int: <1>, string: \"same\", value: <Value expected>]", SamePropertyValuesAs.samePropertyValuesAs((Object)expectedBean));
    }

    public static class SubBeanWithExtraProperty
    extends ExampleBean {
        public SubBeanWithExtraProperty(String stringProperty, int intProperty, Value valueProperty) {
            super(stringProperty, intProperty, valueProperty);
        }

        public String getExtra() {
            return "extra";
        }
    }

    public static class SubBeanWithNoExtraProperties
    extends ExampleBean {
        public SubBeanWithNoExtraProperties(String stringProperty, int intProperty, Value valueProperty) {
            super(stringProperty, intProperty, valueProperty);
        }
    }

    public static class ExampleBean {
        private String stringProperty;
        private int intProperty;
        private Value valueProperty;

        public ExampleBean(String stringProperty, int intProperty, Value valueProperty) {
            this.stringProperty = stringProperty;
            this.intProperty = intProperty;
            this.valueProperty = valueProperty;
        }

        public String getString() {
            return this.stringProperty;
        }

        public int getInt() {
            return this.intProperty;
        }

        public Value getValue() {
            return this.valueProperty;
        }
    }

    public static class Value {
        public final Object value;

        public Value(Object value) {
            this.value = value;
        }

        public String toString() {
            return "Value " + this.value;
        }
    }
}

